<?php
require_once '../config/db.php';

try {
    // Create mpesa_transactions table
    $sql = "CREATE TABLE IF NOT EXISTS mpesa_transactions (
        id INT AUTO_INCREMENT PRIMARY KEY,
        phone VARCHAR(15) NOT NULL,
        amount DECIMAL(10,2) NOT NULL,
        customer_id INT NULL,
        customer_name VARCHAR(255) NULL,
        merchant_request_id VARCHAR(100) NULL,
        checkout_request_id VARCHAR(100) NULL,
        response_code VARCHAR(10) NULL,
        response_description TEXT NULL,
        result_code VARCHAR(10) NULL,
        result_description TEXT NULL,
        mpesa_receipt_number VARCHAR(50) NULL,
        transaction_date DATETIME NULL,
        status ENUM('pending', 'success', 'failed', 'cancelled') DEFAULT 'pending',
        created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
        updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
        INDEX idx_phone (phone),
        INDEX idx_customer_id (customer_id),
        INDEX idx_checkout_request_id (checkout_request_id),
        INDEX idx_status (status),
        INDEX idx_created_at (created_at)
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci";

    $pdo->exec($sql);
    echo "✅ M-Pesa transactions table created successfully!\n";

    // Check if the table was created properly
    $stmt = $pdo->query("DESCRIBE mpesa_transactions");
    $columns = $stmt->fetchAll(PDO::FETCH_COLUMN);
    echo "📋 Table columns: " . implode(', ', $columns) . "\n";

} catch (PDOException $e) {
    echo "❌ Error creating M-Pesa transactions table: " . $e->getMessage() . "\n";
    exit(1);
}

echo "🎉 Migration completed successfully!\n";
?> 